<?php

/**
 * @package           Payamito
 * @link              https://payamito.com/
 * Plugin Name:       Payamito Jet Engine
 * Plugin URI:        https://payamito.com/lib
 * Description:       Payamito Jet Engine plugin
 * Version:           1.5.6
 * Author:            Payamito
 * Author URI:        https://payamito.com/
 * Text Domain:       payamito-jet-engine
 * Domain Path:       /languages
 * Requires PHP: 7.4
 */

// don't call the file directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!defined('PAYAMITO_JET_ENGINE_PLUGIN_FILE')) {
	define('PAYAMITO_JET_ENGINE_PLUGIN_FILE', __FILE__);
}
if (!defined('PAYAMITO_JET_ENGINE_PATH')) {
	define('PAYAMITO_JET_ENGINE_PATH', trailingslashit(plugin_dir_path(__FILE__)));
}
if (!function_exists("payamito_jet_set_locale")) {
	function payamito_jet_set_locale()
	{
		$dirname = str_replace('//', '/', wp_normalize_path(dirname(__FILE__)));
		$mo      = $dirname . '/languages/' . 'payamito-jet-engine-' . get_locale() . '.mo';
		load_textdomain('payamito-jet-engine', $mo);
	}
}
payamito_jet_set_locale();
//all things start to be here
include_once __DIR__ . '/includes/loader.php';

function payamito_jet(): ?Payamito_Jet_Engine_Loader
{
	return Payamito_Jet_Engine_Loader::get_instance();
}
payamito_jet();

/**
 * @author abzarwp
 */
require_once plugin_dir_path( __FILE__ ) . "abzarwp/abzarwp.php";